package ru.yandex.wmtools.common.util.concurrent;

import ru.yandex.common.util.functional.Function;

import java.util.concurrent.Callable;

/**
 * Задача для выполнения функции над аргументом в потоке
 *
 * User: azakharov
 * Date: 12.04.12
 * Time: 11:55
 */
public class ParallelMapTask<X,Y> implements Callable<Y> {
    private final X x;
    private final Function<X,Y> f;

    public ParallelMapTask(X x, Function<X, Y> f) {
        this.x = x;
        this.f = f;
    }

    @Override
    public Y call() throws Exception {
        return f.apply(x);
    }
}
