package ru.yandex.wmtools.common.util.connector;

import java.io.IOException;
import java.util.Locale;

import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.protocol.HttpContext;

/**
 * User: azakharov
 * Date: 09.07.12
 * Time: 12:21
 *
 * Обработчик заголовков content-encoding, позволяющий прозрачно обрабатывать сжатый контент.
 * В отличие от ResponseContentEncoding пропускает неизвестные/некорректные/неправильные заголовки content-encoding
 */
public class ResponseContentEncodingInterceptor implements HttpResponseInterceptor {
    @Override
    public void process(
            final HttpResponse response,
            final HttpContext context) throws HttpException, IOException {
        HttpEntity entity = response.getEntity();

        if (entity != null) {
            Header ceheader = entity.getContentEncoding();
            if (ceheader != null) {
                HeaderElement[] codecs = ceheader.getElements();
                for (HeaderElement codec : codecs) {
                    String codecname = codec.getName().toLowerCase(Locale.US);
                    if ("gzip".equals(codecname) || "x-gzip".equals(codecname)) {
                        response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                        return;
                    } else if ("deflate".equals(codecname)) {
                        response.setEntity(new DeflateDecompressingEntity(response.getEntity()));
                        return;
                    } else if ("identity".equals(codecname)) {
                        return;
                    } else {
                        return;
                    }
                }
            }
        }
    }
}
