package ru.yandex.wmtools.common.util.db;

import ru.yandex.common.framework.filter.QueryFilter;
import ru.yandex.common.framework.filter.Selector;
import ru.yandex.common.framework.filter.SimpleQueryFilter;
import ru.yandex.common.util.xml.XmlConvertable;

/**
 * @author avhaliullin
 */
public class MySQLSimpleQueryFilter implements QueryFilter, XmlConvertable {
    private final SimpleQueryFilter delegate = new SimpleQueryFilter();

    public boolean equals(Object o) {
        return delegate.equals(o);
    }

    public int hashCode() {
        return delegate.hashCode();
    }

    @Override
    public String getConditions() {
        String conditions = delegate.getConditions();
        if (conditions.trim().isEmpty()) {
            return " true ";
        }
        return conditions;
    }

    @Override
    public String getOrder() {
        return delegate.getOrder();
    }

    @Override
    public Object[] getParams() {
        return delegate.getParams();
    }

    @Override
    public void toXml(StringBuilder result) {
        delegate.toXml(result);
    }

    public void addSorter(String name) {
        delegate.addSorter(name);
    }

    public void addSorter(String name, boolean asc) {
        delegate.addSorter(name);
    }

    public void addSorter(String name, String publicName, boolean asc) {
        if (name == null || publicName == null) {
            throw new IllegalArgumentException(name);
        }
        addSorter(new MySQLSorter(name, publicName, asc));
    }

    public void addSorter(MySQLSorter sorter) {
        delegate.addSorter(sorter);
    }

    public void addSelector(Selector<? extends Object> selector) {
        delegate.addSelector(selector);
    }

    public void addSelector(final String name, final Object value) {
        delegate.addSelector(name, value);
    }


    public static class MySQLSorter extends SimpleQueryFilter.Sorter {
        public MySQLSorter(final String name, final boolean asc) {
            super(name, asc);
        }

        public MySQLSorter(final String name, final String publicName, final boolean asc) {
            super(name, publicName, asc);
        }

        public MySQLSorter(final String name, final String publicName, final boolean asc, final boolean defaultSort) {
            super(name, publicName, asc, defaultSort);
        }

        public MySQLSorter(final SimpleQueryFilter.Sorter sorter, final boolean asc) {
            super(sorter, asc);
        }

        public MySQLSorter(final String name, final String publicName, final boolean asc, final boolean defaultSort, final NullOrder nullOrder) {
            super(name, publicName, asc, defaultSort, nullOrder);
        }

        @Override
        public String getOrderBy() {
            if (getNullOrder() == NullOrder.NO_SENSE) {
                return getName();
            }
            return "IF(" + getName() + " IS NULL , 1, 0) " + getOrderByMode(getNullOrder() == NullOrder.AFTER) + ", " + getName();
        }
    }
}
