package ru.yandex.wmtools.common.util.geobase;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import ru.yandex.wmtools.common.data.info.RegionName;

/**
 * @author avhaliullin
 */
public class GeobaseNameHandler extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(GeobaseNameHandler.class);

    private static final String TAG_REGION = "region";
    private static final String ATTRIBUTE_DEFAULT_NAME = "name";

    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_RU_NAME = "runame";
    private static final String ATTRIBUTE_UK_NAME = "ukname";
    private static final String ATTRIBUTE_EN_NAME = "enname";
    private static final String ATTRIBUTE_TR_NAME = "trname";
    private static final String ATTRIBUTE_KK_NAME = "kkname";
    private static final String ATTRIBUTE_BY_NAME = "byname";

    private final GeobaseRegionInfoHandler handler;

    public GeobaseNameHandler(GeobaseRegionInfoHandler handler) {
        this.handler = handler;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!TAG_REGION.equalsIgnoreCase(localName)) {
            return;
        }

        String idStr = attributes.getValue(ATTRIBUTE_ID);
        if (idStr == null) {
            log.error("Region without id");
            return;
        }

        int id = Integer.parseInt(idStr);

        String ruName = attributes.getValue(ATTRIBUTE_RU_NAME);
        String ukName = attributes.getValue(ATTRIBUTE_UK_NAME);
        String enName = attributes.getValue(ATTRIBUTE_EN_NAME);
        String trName = attributes.getValue(ATTRIBUTE_TR_NAME);
        String kkName = attributes.getValue(ATTRIBUTE_KK_NAME);
        String byName = attributes.getValue(ATTRIBUTE_BY_NAME);

        String defaultName = attributes.getValue(ATTRIBUTE_DEFAULT_NAME);

        if (ruName == null) {
            ruName = defaultName;
        }

        RegionName regionName = new RegionName(ruName, ukName, enName, trName, kkName, byName);
        handler.region(id, regionName);
    }
}
