package ru.yandex.wmtools.common.util.geobase;

import org.apache.commons.lang.StringUtils;

import ru.yandex.wmtools.common.data.info.RegionInfo;
import ru.yandex.wmtools.common.data.info.RegionName;

/**
 * @author aherman
 */
public class RegionInfoXmlSerializer {
    public static String serialize(RegionInfo regionInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("<region ");
        appendAttribute(sb, "id", regionInfo.getId());
        appendAttribute(sb, "pid", regionInfo.getParent());

        RegionName regionName = regionInfo.getRegionName();
        if (regionName != null) {
            appendAttribute(sb, "name", StringUtils.defaultString(regionName.getRuName()));
            appendAttribute(sb, "ua_name", StringUtils.defaultString(regionName.getUkName()));
            appendAttribute(sb, "ename", StringUtils.defaultString(regionName.getEnName()));
            appendAttribute(sb, "trname", StringUtils.defaultString(regionName.getTrName()));
        }

        sb.append("/>");

        return sb.toString();
    }

    private static void appendAttribute(StringBuilder sb, String name, String value) {
        sb.append(name).append('=').append('"').append(value).append('"').append(' ');
    }

    private static void appendAttribute(StringBuilder sb, String name, int value) {
        sb.append(name).append('=').append('"').append(value).append('"').append(' ');
    }
}
