package ru.yandex.wmtools.common.util.scheduler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

import ru.yandex.common.scheduler.ScheduleType;
import ru.yandex.common.scheduler.impl.AbstractPicker;
import ru.yandex.common.scheduler.model.ScheduleInfo;
import ru.yandex.common.scheduler.model.TaskDescriptor;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.common.util.db.Setters;

/**
 * @author avhaliullin
 */
class MySqlPicker extends AbstractPicker {
    private JdbcTemplate jdbcTemplate;

    private static final long TEN_SECONDS_IN_MS = 10L * 1000L;

    private static final int MAX_ROWS = 100;

    @Override
    protected List<Pair<TaskDescriptor, ScheduleInfo>> getCandidates(final List<Long> exclusions) {
        final List<Pair<TaskDescriptor, ScheduleInfo>> candidates = Cf.newList();
        final long interval = System.currentTimeMillis() - TEN_SECONDS_IN_MS;
        jdbcTemplate.query(
            " select id, bean_name, params, description, scheduling_type, scheduling_params, last_run_time, last_ping_time" +
                " from sch_task " +
                " where is_disabled = 0 and scheduling_type != 'MANUAL' and last_ping_time < " + interval +
                " and last_run_time < " + interval +
                " order by rand() asc" +
                " for update",
            Setters.chain(Setters.setFetchSize(MAX_ROWS), Setters.setMaxRows(MAX_ROWS)),
            new RowCallbackHandler() {
                @Override
                public void processRow(final ResultSet rs) throws SQLException {
                    Pair<TaskDescriptor, ScheduleInfo> task = extract(rs);
                    if (exclusions == null || !exclusions.contains(task.getFirst().getTaskId())) {
                        candidates.add(task);
                    }
                }
            }
        );
        return candidates;
    }

    private Pair<TaskDescriptor, ScheduleInfo> extract(final ResultSet rs) throws SQLException {
        return Pair.of(
            new TaskDescriptor(rs.getLong(1), rs.getString(2), rs.getString(3), rs.getString(4)),
            new ScheduleInfo(ScheduleType.byName(rs.getString(5).toUpperCase()), rs.getString(6), rs.getLong(7), rs.getLong(8)));
    }


    @Required
    public void setJdbcTemplate(final JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}
