package ru.yandex.wmtools.common.util.scheduler.timetable;

import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.common.scheduler.TaskExecutor;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractLockableDbService;

/**
 * Абстрактный класс задачи с возможностью использования локов на БД.
 *
 * NB! При использовании локов необходимо явно задать lockTemplate в файле настроек.
 *
 * User: azakharov
 * Date: 03.10.12
 * Time: 12:31
 */
public abstract class AbstractLockableTaskExecutor extends AbstractLockableDbService implements TaskExecutor {
    @Override
    public String run(ExecutionContext context) {
        try {
            return runWithRELogging(context);
        } catch (InternalException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract String runWithRELogging(ExecutionContext context) throws InternalException;
}
