package ru.yandex.wmtools.common.util.scheduler.timetable;

import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.common.scheduler.TaskExecutor;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * @author avhaliullin
 */
public abstract class AbstractTaskExecutor extends AbstractDbService implements TaskExecutor {
    @Override
    public String run(ExecutionContext context) {
        try {
            return runWithRELogging(context);
        } catch (InternalException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract String runWithRELogging(ExecutionContext context) throws InternalException;
}
