package ru.yandex.wmtools.common.util.scheduler.timetable;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author avhaliullin
 */
public class CronTimetableTaskTrigger implements InitializingBean {
    private String params;
    private String cronParams;
    private Integer priority;
    private String description;
    private Boolean disabled;
    private String executorName;
    private TaskRegistrator taskRegistrator;

    @Required
    public void setCronParams(String cronParams) {
        this.cronParams = cronParams;
    }

    @Required
    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    @Required
    public void setTaskRegistrator(TaskRegistrator taskRegistrator) {
        this.taskRegistrator = taskRegistrator;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public final void afterPropertiesSet() throws InternalException {
        taskRegistrator.scheduleTask(executorName,
                params,
                description,
                cronParams,
                priority == null ? 1 : priority);
    }
}
