<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="xml" omit-xml-declaration="yes" indent="yes"/>

    <xsl:variable name="req-page-size">
        <xsl:value-of select="/yandexsearch/original-request/request/groupings/groupby/@groups-on-page"/>
    </xsl:variable>
    <xsl:variable name="req-page-num">
        <xsl:value-of select="/yandexsearch/original-request/request/page"/>
    </xsl:variable>
    <xsl:variable name="res-first">
        <xsl:value-of select="/yandexsearch/response/results/grouping/page/@first"/>
    </xsl:variable>
    <xsl:variable name="res-last">
        <xsl:value-of select="/yandexsearch/response/results/grouping/page/@last"/>
    </xsl:variable>
    <xsl:variable name="req-first">
        <xsl:choose>
            <xsl:when test="not($res-first)">0</xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$req-page-num * $req-page-size + 1"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="req-last">
        <xsl:choose>
            <xsl:when test="$req-page-num * $req-page-size + $req-page-size > $res-last">
                <xsl:value-of select="$res-last"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$req-page-num * $req-page-size + $req-page-size"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>



    <xsl:template match="/">
        <xsl:apply-templates select="/yandexsearch"/>
    </xsl:template>

    <xsl:template match="yandexsearch">
        <xsl:element name="{name(.)}">
            <xsl:copy-of select="@version"/>
            <xsl:copy-of select="/yandexsearch/original-request/request"/>
            <xsl:apply-templates select="response"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="response">
        <xsl:element name="{name(.)}">
            <xsl:copy-of select="@date"/>
            <xsl:copy-of select="found"/>
            <xsl:copy-of select="error"/>
            <xsl:apply-templates select="results"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="results">
        <xsl:element name="{name(.)}">
            <xsl:apply-templates select="grouping"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="grouping">
        <xsl:element name="{name(.)}">
            <xsl:copy-of select="@attr"/>
            <xsl:copy-of select="found"/>
            <xsl:copy-of select="found-docs"/>
            <xsl:apply-templates select="page"/>
            <xsl:copy-of select="group[(position() &gt;= $req-first - $res-first + 1) and (position() &lt;= $req-last - $res-first + 1)]"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="page">
        <xsl:element name="{name(.)}">
            <xsl:attribute name="first"><xsl:value-of select="$req-first"/></xsl:attribute>
            <xsl:attribute name="last"><xsl:value-of select="$req-last"/></xsl:attribute>
            <xsl:value-of select="$req-page-num"/>
        </xsl:element>
    </xsl:template>

</xsl:stylesheet>
