<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="xml" omit-xml-declaration="yes" indent="yes"/>
    <xsl:template match="/">
        <xsl:apply-templates select="/yandexsearch"/>
    </xsl:template>

    <xsl:template match="yandexsearch">
        <xsl:element name="{name(.)}">
            <xsl:copy-of select="@version"/>
            <xsl:copy-of select="request"/>
            <xsl:apply-templates select="response"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="response">
        <xsl:element name="{name(.)}">
            <xsl:copy-of select="@date"/>
            <xsl:copy-of select="found"/>
            <xsl:apply-templates select="results"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="results">
        <xsl:element name="{name(.)}">
            <xsl:apply-templates select="grouping"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="grouping">
        <xsl:element name="{name(.)}">
            <xsl:copy-of select="@attr"/>
            <xsl:copy-of select="@mode"/>
            <xsl:copy-of select="@groups-on-page"/>
            <xsl:copy-of select="@docs-in-group"/>
            <xsl:copy-of select="found"/>
            <xsl:copy-of select="found-docs"/>
            <xsl:apply-templates select="page"/>
            <xsl:apply-templates select="group"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="page">
        <xsl:element name="{name(.)}">
            <xsl:attribute name="first">
                <xsl:value-of select="@first"/>
            </xsl:attribute>
            <xsl:attribute name="last">
                <xsl:value-of select="@first + count(/yandexsearch/response/results/grouping/group/doc) - 1"/>
            </xsl:attribute>
            <xsl:value-of select="."/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="group">
        <xsl:if test="not(doccount = 0)">
            <xsl:element name="{name(.)}">
                <xsl:copy-of select="doccount"/>
                <xsl:apply-templates select="doc"/>
            </xsl:element>
        </xsl:if>
    </xsl:template>

    <xsl:template match="doc">
        <xsl:element name="{name(.)}">
            <xsl:copy-of select="@malicious"/>
            <xsl:copy-of select="@malicious-source"/>
            <xsl:copy-of select="domain"/>
            <xsl:copy-of select="url"/>
            <xsl:copy-of select="title"/>
            <xsl:apply-templates select="properties"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="properties">
        <xsl:element name="{name(.)}">
            <xsl:copy-of select="_IsFake"/>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>
