#pragma once

#ifndef WMC_ALGO_6A732423_9B30_44b8_AC32_E0E8304C2C6E
#define WMC_ALGO_6A732423_9B30_44b8_AC32_E0E8304C2C6E

namespace NWebmaster {
//----------------------------------------------------------------------
struct t_null_act {
    template <typename t_type>
    void act(const t_type &) {}

    template <typename t_type>
    void operator()(const t_type &) {}
};

//----------------------------------------------------------------------
template <typename t_map, typename t_map_iter, typename t_pred, typename t_act>
void map_act_erase_if(t_map &m, const t_map_iter &iter1, const t_map_iter &iter2, t_pred &pred, t_act &act) {
    for (t_map_iter iter = iter1; iter != iter2; ) {
        if (pred(*iter)) {
            act(*iter);
            m.erase(iter++);
        } else {
            ++iter;
        }
    }
}

//----------------------------------------------------------------------
template <typename t_map, typename t_pred, typename t_act>
void map_act_erase_if(t_map &m, t_pred &pred, t_act &act) {
    map_act_erase_if(m, m.begin(), m.end(), pred, act);
}

//----------------------------------------------------------------------
template <typename t_map, typename t_map_iter, typename t_pred>
void map_erase_if(t_map &m, const t_map_iter &iter1, const t_map_iter &iter2, t_pred &pred) {
    t_null_act act;
    map_act_erase_if(m, iter1, iter2, pred, act);
}

//----------------------------------------------------------------------
template <typename t_map, typename t_pred>
void map_erase_if(t_map &m, t_pred &pred) {
    map_erase_if(m, m.begin(), m.end(), pred);
}

}

#endif //WMC_ALGO_6A732423_9B30_44b8_AC32_E0E8304C2C6E
