#pragma once

#ifndef ASYNC_BUF_H_56BDCD75B52D459bAAD2B17E7660F886
#define ASYNC_BUF_H_56BDCD75B52D459bAAD2B17E7660F886

#include <util/generic/noncopyable.h>

#include <wmconsole/legacy/util/event.h>
#include <wmconsole/legacy/util/const_size_vector.h>

namespace NWebmaster {
template <typename t_async_buf>
class t_async_buf_writer;

template <typename t_async_buf>
class t_async_buf_reader;

//! Important!!! One writer and one reader!!!
template <typename t_data_type, size_t max_buf_size>
class t_async_buf : public TNonCopyable {
    typedef t_async_buf<t_data_type, max_buf_size> this_type;
    friend class t_async_buf_writer<this_type>;
    friend class t_async_buf_reader<this_type>;
public:
    typedef t_data_type value_type;
    typedef const_size_vector<t_data_type, max_buf_size> collect_type;

    t_async_buf() {
        end_write();
        eh_write.set_event<0>(read_buf_processed_ev);
        eh_read.set_event<0>(ready_read_ev);
        eh_read.set_event<1>(no_write_ev);
        read_buf_processed_ev.set();
    }

    inline void clear() {
        write_buf.clear();
        read_buf.clear();
        finish_ev.reset();
    }

    inline bool is_finish() const   {
        return ((no_write_ev.is_setted()) && (!ready_read_ev.is_setted()));
    }
    inline const collect_type &get_read_buf() const {
        return read_buf;
    }
    inline threads::event &get_writer_connect_event() {
        return writer_connected_ev;
    }

    inline void Acquire() {
        finish_ev.reset();
    }
    inline void Release() {
        finish_ev.set();
    }

private:
    inline void begin_write() {
        no_write_ev.reset();
        writer_connected_ev.set();
    }
    inline void end_write() {
        if (!write_buf.empty()) {
            swap();
        }
        writer_connected_ev.reset();
        no_write_ev.set();
    }

    template <typename t_type>
    inline bool write(const t_type &val) {
        write_buf.push_back(val);
        if (write_buf.size() >= max_buf_size) {
            return swap();
        }
        return true;
    }

    inline void begin_read() {
        eh_read.wait_any();
    }

    inline bool swap() {
        if (finish_ev.is_setted()) {
            return false;
        }
        eh_write.wait_any();
        read_buf_processed_ev.reset();
        read_buf.swap(write_buf);
        ready_read_ev.set();
        return true;
    }

    inline void end_read() {
        ready_read_ev.reset();
        read_buf.clear();
        read_buf_processed_ev.set();
    }

    collect_type write_buf;
    collect_type read_buf;

    threads::event writer_connected_ev;
    threads::event no_write_ev;
    threads::event ready_read_ev;
    threads::event read_buf_processed_ev;
    threads::event finish_ev;
    threads::event_holder<1> eh_write;
    threads::event_holder<2> eh_read;
};

template <typename t_async_buf>
class t_async_buf_writer : public TNonCopyable {
public:
    inline t_async_buf_writer(t_async_buf &buf) : buf(buf)     {
        buf.begin_write();
    }
    inline ~t_async_buf_writer()                               {
        buf.end_write();
    }

    template <typename t_type>
    inline bool write(const t_type &val)                {
        return buf.write(val);
    }

private:
    t_async_buf &buf;
};

template <typename t_async_buf>
class t_async_buf_reader : public TNonCopyable {
public:
    inline t_async_buf_reader(t_async_buf &buf) : buf(buf) {
        buf.begin_read();
    }
    inline ~t_async_buf_reader() {
        buf.end_read();
    }

private:
    t_async_buf &buf;
};

} //namespace NWebmaster

#endif //ASYNC_BUF_H_56BDCD75B52D459bAAD2B17E7660F886
