#include "atomic_primitives.h"

namespace NWebmaster {
namespace threads {

counter::counter()
    : val()
{
}

counter::counter(const value_type &rhs)
    : val(rhs)
{
}

counter::counter(const counter &rhs)
    : val(rhs.val)
{
}

const counter &counter::operator+=(const value_type &rhs) {
    __sync_fetch_and_add(&val, rhs);
    return *this;
}

const counter &counter::operator-=(const value_type &rhs) {
    __sync_fetch_and_add(&val, -rhs);
    return *this;
}

const counter &counter::operator++() {
    return (*this) += 1;
}

const counter &counter::operator--() {
    return (*this) -= 1;
}

counter::operator value_type() const {
    return get();
}

counter::value_type counter::get() const {
    return val;
}

} //threads
} //namespace NWebmaster
