#pragma once

#ifndef CHAR_TABLE_H_1AB96E72_D0BF_470e_8AA6_1B7648050F8D
#define CHAR_TABLE_H_1AB96E72_D0BF_470e_8AA6_1B7648050F8D

namespace NWebmaster {
template <typename t_res_type, t_res_type t_func(char)>
class t_char_table {
public:
    static const unsigned short g_size = 256;

    t_char_table() {
        for (unsigned short i = 0; i < g_size; ++i) {
            unsigned char val = static_cast<unsigned char>(i);
            table[i] = t_func(val);
        }
    }

    inline const t_res_type &operator[](unsigned char i) const {
        return table[i];
    }

private:
    t_res_type table[g_size];
};
}

#endif //CHAR_TABLE_H_1AB96E72_D0BF_470e_8AA6_1B7648050F8D
