#pragma once

#ifndef ACCURATE_DICTIONARY_H_36438DE8177E41dc8DA6A44B7319F9AA
#define ACCURATE_DICTIONARY_H_36438DE8177E41dc8DA6A44B7319F9AA

#include <map>

namespace NWebmaster {
template <typename t_val_type>
class t_accurate_dictionary {
    typedef std::map<istring, t_val_type> t_dict;
    typedef std::map<t_val_type, istring> t_rev_dict;
public:
    inline t_accurate_dictionary(const istring &val_col, const istring &name_col) : val_col(val_col), name_col(name_col) {}

    inline bool is_present_name(const istring &name) const {
        return (dict.end() != dict.find(name));
    }
    inline bool is_present_val(const t_val_type &val) const   {
        return (reverse_dict.end() != reverse_dict.find(val));
    }

    template <typename t_str>
    inline const t_val_type &operator[](const t_str &name) const {
        typename t_dict::const_iterator iter = dict.find(name);
        if (dict.end() == iter) {
            throw std::runtime_error("Key isn't present in the dictionary");
        }
        return iter->second;
    }

    bool empty() const {
        return dict.empty();
    }

    inline void load(Poco::Data::Session &session, const std::string &tbl_name) {
        typedef Poco::Tuple<t_val_type, std::string> t_rec_type;
        typedef std::vector<t_rec_type> t_container;
        t_container values;
        std::ostringstream buf;
        buf << "SELECT " << val_col << ", " << name_col << " from " << tbl_name;
        queries::select(session, buf.str(), values);

        t_dict dict;
        t_rev_dict reverse_dict;

        for (const t_rec_type &rec : values) {
            istring name = rec.template get<1>().c_str();
            t_val_type val = rec.template get<0>();
            dict[name] = val;
            reverse_dict[val] = name;
        }
        this->dict.swap(dict);
        this->reverse_dict.swap(reverse_dict);
    }

private:
    const istring val_col;
    const istring name_col;

    t_dict dict;
    t_rev_dict reverse_dict;
};
}

#endif
