#pragma once

#ifndef DB_WORK_APPLICATION_H_INCLUDED_083425
#define DB_WORK_APPLICATION_H_INCLUDED_083425

#include <wmconsole/legacy/util/application.h>
#include "db_processor.h"

namespace NWebmaster {

class DBWorkApplication : public WMCApplication {
public:
    static const std::string OP_INPUT_FILE;

    DBWorkApplication() : WMCApplication() {}
    ~DBWorkApplication() override {}

protected:
    void defineOptions(OptionSet &options) override {
        WMCApplication::defineOptions(options);
        WMCApplication::defineDbOptions(options);

        options.addOption(
            Option(OP_INPUT_FILE, "i",
                   "Input file (list of hostnames)\n")
            .required(false)
            .repeatable(false)
            .argument("file")
            .binding(OP_INPUT_FILE)
        );
    }

    int doMain(const std::vector<std::string> &args) override;
    virtual DBProcessor *createDBProcessor(Poco::Data::Session &session) = 0;
};

} // namespace NWebmaster

#endif
