#include "application.h"
#include "db_processor.h"
#include <wmconsole/legacy/util/mysql_url.h>
#include <iostream>

using Poco::Data::Keywords::use;
using Poco::Data::Keywords::into;
using Poco::Data::Keywords::now;

class MyDBProcessor : public NWebmaster::DBProcessor {
public:
    MyDBProcessor(Poco::Data::Session &session) : NWebmaster::DBProcessor(session) {
        Poco::Int64 count;
        fSession << "select count(*) from tbl_hosts", into(count), now;
        std::cout << "number of hosts in db: " << count << std::endl;
    }
    ~MyDBProcessor() override {}
    void process(const std::string &key, const std::string & /*value*/) override {
        Poco::Int64 hostId;
        fSession << "select host_id from tbl_hosts where name = ?", use(key), into(hostId), now;
        std::cout << "name=" << key << ", host_id=" << hostId << std::endl;
    };
};

class MyApplication : public NWebmaster::DBWorkApplication {
public:

    MyApplication() {
        Poco::Logger::get("").setChannel(nullptr);
    }

    ~MyApplication() override {}

protected:

    void defineOptions(OptionSet &options) override {
        NWebmaster::DBWorkApplication::defineDbOptions(options);
    }

    NWebmaster::DBProcessor *createDBProcessor(Poco::Data::Session &session) override {
        return new MyDBProcessor(session);
    }
};

POCO_APP_MAIN(MyApplication);
