#pragma once

#ifndef MULTI_SELECT_B393E795_1522_435b_B1BC_5C834940D10E
#define MULTI_SELECT_B393E795_1522_435b_B1BC_5C834940D10E

#include <exception>
#include <Poco/Data/Session.h>
#include <Poco/Data/Statement.h>
#include <Poco/Data/RecordSet.h>
#include <wmconsole/legacy/util/insert_policy.h>
#include <wmconsole/legacy/util/event.h>

namespace NWebmaster {
namespace queries {

template <typename t_container>
inline void select(Poco::Data::Session &session, const std::string &query, t_container &cont) {
    using namespace Poco::Data;
    using namespace Poco::Data::Keywords;

    Statement stmt(session);
    stmt << query, into(cont), now;
}

template <typename t_container>
inline void select(Poco::Data::Session &session, const std::string &query, t_container &cont, const threads::event &close_ev, int lim = 256) {
    using namespace Poco::Data;
    using namespace Poco::Data::Keywords;

    Statement stmt(session);
    stmt << query, into(cont), limit(lim);

    while (!stmt.done()) {
        stmt.execute();
        if (close_ev.is_setted()) {
            throw std::logic_error("Close event occured");
        }
    }
}


}//queries
}//namespace NWebmaster

#endif
