#pragma once

#ifndef QUERIES_A63C7B5E_A7BE_4a8f_8BA6_6737A1C67E3D
#define QUERIES_A63C7B5E_A7BE_4a8f_8BA6_6737A1C67E3D

#include <Poco/Data/Session.h>
#include <Poco/Data/Statement.h>
#include <Poco/Data/RecordSet.h>
#include "multi_select.h"

namespace NWebmaster {
namespace queries {

//-----------------------------------------------------------------------------------
inline bool get_host_id(Poco::Data::Session &session, const std::string &hostName, Poco::Int64 &hostId) {
    using namespace Poco::Data::Keywords;

    Poco::Data::Statement select(session);
    select << "SELECT host_id FROM tbl_hosts WHERE name = ?", use(hostName);
    select.execute();
    Poco::Data::RecordSet rs(select);
    if (0 == rs.rowCount()) {
        return false;
    }
    hostId = rs.value(0, 0).convert<Poco::Int64>();
    return true;
}

//-----------------------------------------------------------------------------------
template <typename t_container>
inline void get_all_users_hosts(Poco::Data::Session &session, t_container &cont, const threads::event &close_ev) {
    select(session,
           "SELECT lcase(name) FROM (SELECT DISTINCT host_id FROM tbl_users_hosts) tbl_ NATURAL JOIN tbl_hosts WHERE mirror_id IS NULL",
           cont, close_ev);
}

template <typename t_container>
inline void get_all_verified_hosts(Poco::Data::Session &session, t_container &cont, const threads::event &close_ev) {
    select(session,
           "SELECT lcase(name) FROM (SELECT DISTINCT host_id FROM tbl_users_hosts WHERE state IN(1, 12, 13)) tbl_ NATURAL JOIN tbl_hosts WHERE mirror_id IS NULL",
           cont, close_ev);
}

} //queries
} //namespace NWebmaster

#endif //QUERIES_A63C7B5E_A7BE_4a8f_8BA6_6737A1C67E3D
