#pragma once

#ifndef SESSION_FUNC_3D8A8917_561D_4fc1_905C_65A6A61D3E07
#define SESSION_FUNC_3D8A8917_561D_4fc1_905C_65A6A61D3E07

#include <Poco/Data/Session.h>

namespace NWebmaster {
//-----------------------------------------------------------------------------------
struct t_session_func {
    template<typename t_func_type>
    void operator()(const t_func_type &func, Poco::Data::Session &session) const;
};

//-----------------------------------------------------------------------------------
template <typename t_func_type>
void session_func(const t_func_type &func, Poco::Data::Session &session);

//-----------------------------------------------------------------------------------
template <typename t_func_type>
void t_session_func::operator()(const t_func_type &func, Poco::Data::Session &session) const {
    session_func(func, session);
}

//-----------------------------------------------------------------------------------
template <typename t_func_type>
void session_func(const t_func_type &func, Poco::Data::Session &session)
try {
    session.begin();
    func(session);
    session.commit();
} catch (...) {
    session.rollback();
    throw;
}

} //namespace NWebmaster

#endif //SESSION_FUNC_3D8A8917_561D_4fc1_905C_65A6A61D3E07
