#pragma once

#ifndef DAT_FILE_UTILS_H_C171C91DB6AB42a783B46494DD37B6BD
#define DAT_FILE_UTILS_H_C171C91DB6AB42a783B46494DD37B6BD

#include <sys/stat.h>
#include <util/generic/yexception.h>
#include <unistd.h>

namespace NWebmaster {
namespace dat_files {

struct sys_info {
    static off_t page_size() {
        static off_t g_page_size = 0;
        if (g_page_size) {
            return g_page_size;
        }
        g_page_size = sysconf(_SC_PAGESIZE);
        return g_page_size;
    }

    static void get_stat(const std::string &path, struct stat &res) {
        if (0 != stat(path.c_str(), &res)) {
            ythrow yexception() << "Cannot get stat for: " << path;
        }
    }
};


template <typename t_dat_file_type>
void safe_dat_close(t_dat_file_type &f) {
    try {
        f.Close();
    } catch (yexception &e) {
        log_error << "Cannot close some db file. Exception: " << e.what();
    }
}

template <typename t_dat_file_type>
void safe_dat_open(t_dat_file_type &f, const std::string &path, struct stat &st) {
    try {
        sys_info::get_stat(path, st);
        if (sys_info::page_size() > st.st_size) {
            ythrow yexception() << "Cannot open: " << path << " File size is smaller or equal " << sys_info::page_size();
        }
        f.Open(path.c_str());
    } catch (yexception &e) {
        log_info << "Can not open some files. Exception: " << e.what() << " " << path;
    }
}

template <typename t_dat_file_type>
void safe_check_reinit(t_dat_file_type &f, const std::string &path, struct stat &st) {
    try {
        struct stat cur_st;
        sys_info::get_stat(path, cur_st);
        if ((cur_st.st_size == st.st_size) &&
                (cur_st.st_mtime == st.st_mtime)) {
            return;
        }
        f.reinit();
    } catch (...) {}
}

} //dat_files
} //namespace NWebmaster

#endif //DAT_FILE_UTILS_H_C171C91DB6AB42a783B46494DD37B6BD
