#pragma once

#include <string>
#include <vector>

#include <util/generic/ptr.h>

namespace NWebmaster {
    //do not own any data
    struct TPostRequest {
        inline TPostRequest(const std::string& url)
            : Url(&url)
            , Data(nullptr)
            , Headers(nullptr)
            , Tout(1000)
        {
        }

        inline TPostRequest& SetData(const std::string& data) noexcept {
            Data = &data;

            return *this;
        }

        inline TPostRequest& SetContentType(const std::string& contentType) noexcept {
            ContentType = contentType;

            return *this;
        }

        inline TPostRequest& SetTimeout(long timeout) noexcept {
            Tout = timeout;

            return *this;
        }

        inline TPostRequest& SetHeaders(const std::vector<std::string>& headers) noexcept {
            Headers = &headers;

            return *this;
        }

        TAtomicSharedPtr<std::string> Perform();

        const std::string *Url;
        const std::string *Data;
        std::string ContentType;
        const std::vector<std::string>* Headers;
        long Tout;
    };

    std::string HttpGet(const std::string& url, long timeout = 1000);
    std::string HttpPost(const std::string& url, const std::string& data, const std::string &contentType = "", long timeout = 1000);

    void Quote(std::string& url, const char* safe = "");
}

