#pragma once

#ifndef ISTRING_H_F7BD36A05EF8411687938D4399115A8F
#define ISTRING_H_F7BD36A05EF8411687938D4399115A8F

#include <stdio.h>
#include <ctype.h>
#include <string>

namespace NWebmaster {

namespace _inner_istring {

template<class C>
struct char_traits_nocase : public std::char_traits<C> {
    static bool eq( const C &c1, const C &c2 )               {
        return ::toupper(c1) == ::toupper(c2);
    }
    static bool lt( const C &c1, const C &c2 )               {
        return ::toupper(c1) < ::toupper(c2);
    }
    static int compare( const C *s1, const C *s2, size_t N ) {
        return strnicmp(s1, s2, N);
    }
    static const char *find( const C *s, size_t N, const C &a ) {
        for (size_t i=0; i<N; ++i) {
            if (::toupper(s[i]) == ::toupper(a)) {
                return s+i ;
            }
        }
        return nullptr ;
    }

    template <typename int_type>
    static bool eq_int_type(const int_type &c1, const int_type &c2) {
        return ::toupper(c1) == ::toupper(c2);
    }
};

} //_inner_istring

typedef std::basic_string<char, _inner_istring::char_traits_nocase<char> > istring;

inline std::ostream &operator<<(std::ostream &os, const istring &t) {
    return (os << t.c_str());
}

} //namespace NWebmaster

#endif //ISTRING_H_F7BD36A05EF8411687938D4399115A8F
