#pragma once

#ifndef KW_READER_4CDEDF9C6B8D48b789E310EEBCBA4284
#define KW_READER_4CDEDF9C6B8D48b789E310EEBCBA4284

#include <library/cpp/bucket_quoter/bucket_quoter.h>
#include <yweb/robot/kiwi/clientlib/client.h>

namespace NWebmaster {

class TRpsQuoter : private TBucketQuoter<int> {
public:
    TRpsQuoter(ui32 rps)
        : TBucketQuoter<int>(rps *Scale, Scale, nullptr, nullptr, nullptr) {
    }

    void Throttle() {
        Sleep();
        Use(Scale);
    }

private:
    static const ui32 Scale = 1000;
};

class TKiwiReader : public NKiwi::TSyncReader {
public:

    enum EQueryResult {
        QUERY_OK,
        QUERY_NOT_FOUND,
        QUERY_ERROR,
    };

    TKiwiReader(NKiwi::TSession &session, const TString &query, TRpsQuoter *quoter, ui32 use_deltas = 0)
        : TSyncReader(session, 50, query, nullptr, use_deltas), kw_quoter(quoter) {
    }

    ~TKiwiReader() override {
    }

    EQueryResult Read(const TString &key) {
        if (!!kw_quoter) {
            kw_quoter->Throttle();
        }

        EReadStatus eState = TSyncReader::Read(key, temp, READ_ALL_REPLICAS);

        last_error = StatusText(eState);

        switch(eState) {
        case READ_OK:
        case READ_PARTIAL:
            return QUERY_OK;
        case READ_NOKEY:
            return QUERY_NOT_FOUND;
        default:
            ;
        }

        return QUERY_ERROR;
    }

    TString GetLastError() {
        return last_error;
    }

    template <typename T>
    inline T GetData(int num) const {
        T value;

        if (!GetTuple(num)->GetValue<T>(value)) {
            ythrow yexception() << "unable to process TTuple::GetValue() i = " << num;
        }

        return value;
    }

    bool IsNull(int num) const {
        return GetTuple(num)->ParseData().IsNull();
    }

private:

    const NKiwi::NTuples::TTuple *GetTuple(int num) const {
        NKiwi::NTuples::TTupleIterator iter = temp.GetIterator();

        while ((num != 0) && (iter.IsValid())) {
            ++iter;
            --num;
        }

        if ((0 != num) || (!iter.IsValid())) {
            ythrow yexception() << "NKiwi::NTuples::TTupleIterator isn't valid";
        }

        const NKiwi::NTuples::TTuple *tuple = iter.Current();

        if (nullptr == tuple) {
            ythrow yexception() << "NKiwi::NTuples::TTuple* is NULL";
        }

        return tuple;
    }

private:

    NKiwi::TKiwiObject temp;
    TRpsQuoter *kw_quoter;
    TString last_error;
};

template <>
inline std::string TKiwiReader::GetData<std::string>(int num) const {
    const NKiwi::NTuples::TTuple *tuple = GetTuple(num);
    return std::string((const char *)tuple->GetData(), tuple->GetSize());
}

template <>
inline TString TKiwiReader::GetData<TString>(int num) const {
    const NKiwi::NTuples::TTuple *tuple = GetTuple(num);
    return TString((const char *)tuple->GetData(), tuple->GetSize());
}

} //namespace NWebmaster

#endif //KW_READER_4CDEDF9C6B8D48b789E310EEBCBA4284
