#pragma once

#ifndef WMC_POCOLOGGER_H_INCLUDED
#define WMC_POCOLOGGER_H_INCLUDED

#include <string>
#include "trace.h"

// Poco::Logger support
#include <Poco/Logger.h>

namespace NWebmaster {

typedef mem_fun_binder_t<void, Poco::Logger, const std::string &>   PocoLogFunctor;
typedef PocoLogFunctor::mem_t                                      PocoLogMethod;

} // namespace NWebmaster

//using NWebmaster::mem_fun_binder_t;
//using NWebmaster::log_helper;
using NWebmaster::PocoLogFunctor;
using NWebmaster::PocoLogMethod;

// ok : ctor with one parameter
//#define tr_stream log_helper<PocoLogFunctor>(PocoLogFunctor(logger, &Poco::Logger::error)).get() << __func__ << "> "
// ok : most generic mem_fun_ptr type. Take care if method is overloaded
//#define tr_stream log_helper< mem_fun_binder_t<void, Poco::Logger, const string&> >(mem_fun_binder(logger, &Poco::Logger::error)).get() << __func__ << "> "
// ok : specialized template, ctor with 2 parameters

#ifdef NDEBUG
#define ERROR_LOCATION
#define TRACE_LOCATION
#else
#define ERROR_LOCATION    <<__FILE__"#"<<__LINE__<<":"<<__func__<<"> "
#define TRACE_LOCATION    <<__func__ << "> "
#endif // NDEBUG

#undef log_trace
#undef log_debug
#undef log_info
#undef log_warn
#undef log_error
#undef log_fatal
#define POCO_LOGGER &logger()
#define log_trace   NWebmaster::log_helper<PocoLogMethod>(POCO_LOGGER, &Poco::Logger::trace).get() TRACE_LOCATION
#define log_debug   NWebmaster::log_helper<PocoLogMethod>(POCO_LOGGER, &Poco::Logger::debug).get() TRACE_LOCATION
#define log_info    NWebmaster::log_helper<PocoLogMethod>(POCO_LOGGER, &Poco::Logger::information).get() TRACE_LOCATION
#define log_warn    NWebmaster::log_helper<PocoLogMethod>(POCO_LOGGER, &Poco::Logger::warning).get() TRACE_LOCATION
#define log_error   NWebmaster::log_helper<PocoLogMethod>(POCO_LOGGER, &Poco::Logger::error).get() ERROR_LOCATION
#define log_fatal   NWebmaster::log_helper<PocoLogMethod>(POCO_LOGGER, &Poco::Logger::fatal).get() ERROR_LOCATION
#define log_stat    log_info << "[STAT] "

extern Poco::Logger &logger();

#endif // WMC_POCOLOGGER_H_INCLUDED
