#pragma once

#ifndef _LOG_UTIL_H_INCLUDED_
#define _LOG_UTIL_H_INCLUDED_

#include <Poco/Logger.h>
#include <sstream>

using Poco::Message;



/**
Logs a message to a specified logger with the TRACE level.

@param logger the logger to be used.
@param message the message string to log.
*/
#define WMCLOG_TRACE(logger, message) { \
        if (logger.is(Poco::Message::PRIO_TRACE)) { \
            std::ostringstream os; \
            os << message; \
            try { logger.trace(os.str()); } catch (Poco::FileException& e) {} } }


/**
Logs a message to a specified logger with the DEBUG level.

@param logger the logger to be used.
@param message the message string to log.
*/
#define WMCLOG_DEBUG(logger, message) { \
        if (logger.is(Poco::Message::PRIO_DEBUG)) { \
            std::ostringstream os; \
            os << message; \
            try { logger.debug(os.str()); } catch (Poco::FileException& e) {}} }



/**
Logs a message to a specified logger with the INFO level.

@param logger the logger to be used.
@param message the message string to log.
*/
#define WMCLOG_INFO(logger, message) { \
        if (logger.is(Poco::Message::PRIO_INFORMATION)) {   \
            std::stringstream os; \
            os << message; \
            try { logger.information(os.str()); } catch (Poco::FileException& e) {}} }

/**
Logs a message to a specified logger with the WARN level.

@param logger the logger to be used.
@param message the message string to log.
*/
#define WMCLOG_WARN(logger, message) { \
        if (logger.is(Poco::Message::PRIO_WARNING)) {   \
            std::ostringstream os; \
            os << message; \
            try { logger.warning(os.str()); } catch (Poco::FileException& e) {} } }


/**
Logs a message to a specified logger with the ERROR level.

@param logger the logger to be used.
@param message the message string to log.
*/
#define WMCLOG_ERROR(logger, message) { \
        if (logger.is(Poco::Message::PRIO_ERROR)) { \
            std::ostringstream os; \
            os << message; \
            try { logger.error(os.str()); } catch (Poco::FileException& e) {} } }

/**
Logs a message to a specified logger with the FATAL level.

@param logger the logger to be used.
@param message the message string to log.
*/
#define WMCLOG_FATAL(logger, message) { \
        if (logger.is(Poco::Message::PRIO_FATAL)) { \
            std::ostringstream os; \
            os << message; \
            try { logger.fatal(os.str()); } catch (Poco::FileException& e) {}} }

#endif
