#pragma once

#ifndef _MYSQL_URL_H_INCLUDED_
#define _MYSQL_URL_H_INCLUDED_

#include <string>
#include <algorithm>
#include <functional>

#include <Poco/Logger.h>

#include "logutil.h"

namespace NWebmaster {

class MySQLUrl {
public:
    MySQLUrl(const std::string &url);
    virtual ~MySQLUrl() {};

    const std::string &getConnectionString() const {
        return fConnectionString;
    }
    const std::string &getCommandlineString() const {
        return fCommandlineString;
    }

private:
    static Poco::Logger &logger() {
        static Poco::Logger &fLogger = Poco::Logger::get("MySQLUrl");
        return fLogger;
    };

    std::string fName;
    std::string fHost;
    unsigned int fPort;
    std::string fUser;
    std::string fPassword;

    std::string fConnectionString;
    std::string fCommandlineString;
};

} // namespace NWebmaster

#endif
