#pragma once

#ifndef _WMC_PATTERN_FORMATTER_H_INCLUDED_
#define _WMC_PATTERN_FORMATTER_H_INCLUDED_

#include <Poco/Foundation.h>
#include <Poco/Formatter.h>
#include <Poco/Message.h>

using std::string;
using Poco::Formatter;
using Poco::Message;

namespace NWebmaster {

class WMCPatternFormatter: public Formatter {
public:
    WMCPatternFormatter();

    WMCPatternFormatter(const string &format);

    ~WMCPatternFormatter() override;

    void format(const Message &msg, string &text) override;

    void setProperty(const string &name, const string &value) override;

    string getProperty(const string &name) const override;

    static const string PROP_PATTERN;
    static const string PROP_TIMES;

protected:
    static const string &getPriorityName(int);

private:
    bool        _localTime;
    string _pattern;
};

} // namespace NWebmaster

#endif
