#pragma once

#ifndef SAFE_FUNC_15B01DE7_B509_4209_9FFF_707817922557
#define SAFE_FUNC_15B01DE7_B509_4209_9FFF_707817922557

#include <exception>
#include <Poco/Exception.h>
#include <wmconsole/legacy/util/logger.h>
#include <wmconsole/legacy/util/thr_apps/except_singleton.h>

namespace NWebmaster {

//-----------------------------------------------------------------------------------
struct t_safe_func {
    typedef void result_type;

    template <typename t_func_type>
    void operator()(const t_func_type &func) const;
};

//-----------------------------------------------------------------------------------
struct t_only_log_safe_func {
    typedef void result_type;

    template <typename t_func_type>
    void operator()(const t_func_type &func) const;
};

//-----------------------------------------------------------------------------------
template <typename t_func_type>
void safe_func(const t_func_type &func);

//-----------------------------------------------------------------------------------
template <typename t_func_type>
void only_log_safe_func(const t_func_type &func);

//-----------------------------------------------------------------------------------
template <typename t_func_type>
void t_safe_func::operator()(const t_func_type &func) const {
    return safe_func(func);
}

//-----------------------------------------------------------------------------------
template <typename t_func_type>
void t_only_log_safe_func::operator()(const t_func_type &func) const {
    return only_log_safe_func(func);
}

//-----------------------------------------------------------------------------------
template <typename t_func_type>
void safe_func(const t_func_type &func)
try {
    func();
} catch (Poco::Exception &e) {
    log_error << "Poco::Exception " << e.message();
    t_except_single::instance().except_occur(e.message());
} catch (std::exception &e) {
    log_error << "std::exception " << e.what();
    t_except_single::instance().except_occur(e.what());
} catch ( ... ) {
    log_error << "Unknown processing error!";
    t_except_single::instance().except_occur("Unknown processing error!");
}

//-----------------------------------------------------------------------------------
template <typename t_func_type>
void only_log_safe_func(const t_func_type &func)
try {
    func();
} catch (Poco::Exception &e) {
    log_error << "Poco::Exception " << e.message();
} catch (std::exception &e) {
    log_error << "std::exception " << e.what();
} catch ( ... ) {
    log_error << "Unknown processing error!";
}

}

#endif //SAFE_FUNC_15B01DE7_B509_4209_9FFF_707817922557
