#pragma once

#ifndef WMC_SESSION_FACTORY__H
#define WMC_SESSION_FACTORY__H

#include <string>
#include <vector>
#include <Poco/Data/Session.h>
#include "Poco/Mutex.h"
//#include "Poco/AutoPtr.h"

namespace NWebmaster {

//! \todo Add locking policy
class SessionProxy {
public:
    SessionProxy(const std::string &dbkey, const std::string &url)
        : _dbkey(dbkey), _url(url), _ptr(nullptr) {}

    ~SessionProxy() {
        delete _ptr;
    }

    operator Poco::Data::Session &() const {
        Poco::FastMutex::ScopedLock lock(_mutex);
        if (!_ptr) {
            _ptr = new Poco::Data::Session(_dbkey, _url);
        }
        return *_ptr;
    }

//      operator const Poco::Data::Session& () const
//      {
//          Poco::FastMutex::ScopedLock lock(_mutex);
//          if (!_ptr) {
//              _ptr = new Poco::Data::Session(_dbkey, _url);
//          }
//          return *_ptr;
//      }

private:
    const std::string   _dbkey;
    const std::string   _url;
    mutable Poco::Data::Session    *_ptr;
    static Poco::FastMutex _mutex;
};

//  typedef std::vector<SessionPtr>  SessionList;

} // namespace NWebmaster

#endif //WMC_SESSION_FACTORY__H

