#pragma once

#ifndef SITEMAPS_LOADING_23059F0E_2EA9_4870_B546_132083F83A53
#define SITEMAPS_LOADING_23059F0E_2EA9_4870_B546_132083F83A53

#include <wmconsole/legacy/util/sitemaps/sitemaps_loading_inner.h>

namespace NWebmaster {

//----------------------------------------------------------------------
template <typename t_dat_files_holder>
void load_sitemaps_from_dat_files(ui32 host_id,
                                  t_dat_files_holder &dat_files,
                                  t_stms_dat_map &res,
                                  bool from_loader = false
                                 ) {
    using namespace NWebmaster::sitemaps_inner;
    load_sitemaps(res, host_id, dat_files, from_loader);
}

//----------------------------------------------------------------------
template <typename t_stms_db, typename t_dat_files_holder, typename t_dict>
void place_sitemaps_to_db(t_stms_db &stm_db,
                          t_dat_files_holder &dat_files,
                          t_stms_dat_map &stms,
                          const t_dict &tbl_dic_sitemap_error_type,
                          std::map<urlid_t, Poco::Int64> &dat_id_to_db_id) {
    using namespace NWebmaster::sitemaps_inner;

    dat_id_to_db_id.clear();
    if (stms.empty()) {
        stm_db.delete_all_sitemaps();
        return;
    }

    typedef typename t_stms_db::t_stm_collection t_db_coll;
    t_db_coll db_coll;
    stm_db.preload();
    stm_db.get_all_sitemaps(db_coll);

    {
        //delete sitemaps from db
        typedef std::set<Poco::Int64> t_db_id_coll;
        t_db_id_coll remove_id_coll;
        t_key_pred<t_stms_dat_map> pred(stms, true);
        t_copy_id_act<t_db_id_coll> act(remove_id_coll);
        map_act_erase_if(db_coll, pred, act);
        stm_db.remove_sitemaps(remove_id_coll);
    }

    t_smtms_indexes_map indexes_map;
    {
        //sitemap-indexes process
        t_stms_dat_map index_stms;
        {
            //split by indexes
            t_index_stms_pred<t_stms_dat_map> pred;
            t_copy_map_act<t_stms_dat_map> act(index_stms);
            map_act_erase_if(stms, pred, act);
        }

        t_stms_dat_map stms_for_insert;
        {
            //split by insert/update
            t_key_pred<t_db_coll> pred(db_coll, true);
            t_copy_map_act<t_stms_dat_map> act(stms_for_insert);
            map_act_erase_if(index_stms, pred, act);
        }

        typedef typename t_stms_dat_map::value_type value_type;
        for (const value_type &val : stms_for_insert) {
            Poco::Int64 new_id = insert_sitemap_index(val.first, val.second, dat_files, stm_db, tbl_dic_sitemap_error_type, indexes_map);
            if (-1 != new_id) {
                dat_id_to_db_id[val.second.id()] = new_id;
            }
        }

        for (const value_type &val : index_stms) {
            Poco::Int64 new_id = update_sitemap_index(val.first, val.second, dat_files, stm_db, tbl_dic_sitemap_error_type, db_coll, indexes_map);
            if (-1 != new_id) {
                dat_id_to_db_id[val.second.id()] = new_id;
            }
        }
    }

    {
        //sitemaps process

        t_stms_dat_map stms_for_insert;
        {
            //split by insert/update
            t_key_pred<t_db_coll> pred(db_coll, true);
            t_copy_map_act<t_stms_dat_map> act(stms_for_insert);
            map_act_erase_if(stms, pred, act);
        }

        typedef typename t_stms_dat_map::value_type value_type;
        for (const value_type &val : stms_for_insert) {
            Poco::Int64 new_id = insert_sitemap(val.first, val.second, dat_files, stm_db, tbl_dic_sitemap_error_type, indexes_map);
            if (-1 != new_id) {
                dat_id_to_db_id[val.second.id()] = new_id;
            }
        }

        for (const value_type &val : stms) {
            Poco::Int64 new_id = update_sitemap(val.first, val.second, dat_files, stm_db, tbl_dic_sitemap_error_type, db_coll, indexes_map);
            if (-1 != new_id ) {
                dat_id_to_db_id[val.second.id()] = new_id;
            }
        }

        stms.clear();
    }
    stm_db.postload();
}

} //namespace NWebmaster

#endif
