#pragma once

#ifndef __STRING_UTIL_H__
#define __STRING_UTIL_H__

#include <vector>
#include <string>

#include <cstring> // strchr

namespace NWebmaster {

inline std::string makeSeparatedString(const std::vector<std::string> &v, char delim) {
    std::string s;
    for (unsigned int i = 0; i < v.size(); i++) {
        if(i != 0) {
            s += delim;
        }
        s += "\"" + v[i] + "\"";
    }
    return s;
}

inline std::string makeSeparatedString(const char *str, unsigned int cnt, char delim) {
    std::string s;
    if(!str) {
        return s;
    }

    for (unsigned int i = 0; i < cnt; i++) {
        if(i != 0) {
            s += delim;
        }
        s += str;
    }
    return s;
}

inline int parseString(const char *str, char delim, std::vector<std::string> &result) {
    result.clear();
    if(!str || !*str) {
        return 0;
    }

    const char *p = str;
    const char *p1;

    for (;;) {
        p1 = strchr(p, delim);
        if(p1) {
            result.push_back(std::string(p, p1 - p));
        } else {
            result.push_back(std::string(p));
        }

        if(!p1) {
            break;
        }
        p = p1 + 1;
    }

    return result.size();
}

} // namespace NWebmaster

#endif
