#pragma once

#ifndef EXCEPT_SINGLETON_CAB88700_710D_40ac_B724_D35411935D89
#define EXCEPT_SINGLETON_CAB88700_710D_40ac_B724_D35411935D89

#include <wmconsole/legacy/util/thr_apps/close_event.h>

#include <util/system/mutex.h>

namespace NWebmaster {

//-----------------------------------------------------------------------------------
class t_except_single {
public:
    static t_except_single &instance() {
        static t_except_single g_instance;
        return g_instance;
    }

    inline bool is_except() const;
    inline std::string except() const;
    inline void except_occur(const std::string &what);
private:
    t_except_single() {}

    mutable TMutex locker;
    std::string except_str;
};

bool t_except_single::is_except() const {
    TGuard<TMutex> guard(locker);
    return except_str.empty();
}

std::string t_except_single::except() const {
    TGuard<TMutex> guard(locker);
    return except_str;
}

void t_except_single::except_occur(const std::string &what) {
    TGuard<TMutex> guard(locker);
    if (except_str.empty()) {
        except_str = what;
        t_close_event::instance().set();
    }
}

} //namespace NWebmaster

#endif
