#pragma once

#ifndef WMC_THREADS_CADFBDA1_9463_47bc_BF82_36C7A5876274
#define WMC_THREADS_CADFBDA1_9463_47bc_BF82_36C7A5876274

#include <util/generic/ptr.h>
#include <util/thread/factory.h>

namespace NWebmaster {
namespace threads {
namespace detail {

template <typename TFunction>
struct TRunAble: public IThreadFactory::IThreadAble {
    inline TRunAble(const TFunction &cb)
        : cb(cb)
        , done(false)
    {
    }

    ~TRunAble() override {
    }

    void DoExecute() override {
        cb();
        done = true;
    }

    TFunction cb;
    bool done;
};

} //detail

class thread {
public:
    thread() {
    }

    template <typename TFunction>
    thread(const TFunction &cb)
        : Runner(new detail::TRunAble<TFunction>(cb))
    {
         Thread = SystemThreadFactory()->Run(Runner.Get());
    }

    void join() {
        Thread->Join();
    }

private:
    TAutoPtr<IThreadFactory::IThreadAble> Runner;
    TAutoPtr<IThreadFactory::IThread> Thread;
};
} //threads
} //namespace NWebmaster

#endif //WMC_THREADS_CADFBDA1_9463_47bc_BF82_36C7A5876274
