package org.apache.juli.logging;

import org.slf4j.Logger;

/**
 * @author aherman
 */
public class JuliLogToSLF4JLog implements Log {
    private final Logger log;

    public JuliLogToSLF4JLog(Logger log) {
        this.log = log;
    }

    @Override
    public boolean isTraceEnabled() {
        return log.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return log.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return log.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return log.isErrorEnabled();
    }

    @Override
    public boolean isFatalEnabled() {
        return log.isErrorEnabled();
    }

    @Override
    public void trace(Object message) {
        log.trace("" + message);
    }

    @Override
    public void trace(Object message, Throwable t) {
        log.trace("" + message, t);
    }

    @Override
    public void debug(Object message) {
        log.debug("" + message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        log.debug("" + message);
    }

    @Override
    public void info(Object message) {
        log.info("" + message);
    }

    @Override
    public void info(Object message, Throwable t) {
        log.info("" + message, t);
    }

    @Override
    public void warn(Object message) {
        log.warn("" + message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        log.warn("" + message, t);
    }

    @Override
    public void error(Object message) {
        log.error("" + message);
    }

    @Override
    public void error(Object message, Throwable t) {
        log.error("" + message, t);
    }

    @Override
    public void fatal(Object message) {
        log.error("" + message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        log.error("" + message, t);
    }
}
