package org.apache.juli.logging;

import org.slf4j.LoggerFactory;

/**
 * Delegate Apache Juli logging events to SLF4J directly
 *
 * @author aherman
 */
public class LogFactory {
    public static LogFactory getFactory() {
        return new LogFactory();
    }

    public static Log getLog(Class<?> clazz) {
        return new JuliLogToSLF4JLog(LoggerFactory.getLogger(clazz));
    }

    public static Log getLog(String name) {
        return new JuliLogToSLF4JLog(LoggerFactory.getLogger(name));
    }

    public Log getInstance(Class<?> clazz) {
        return new JuliLogToSLF4JLog(LoggerFactory.getLogger(clazz));
    }

    public Log getInstance(String name) {
        return new JuliLogToSLF4JLog(LoggerFactory.getLogger(name));
    }

    // Do nothing
    public void release() {
    }

    public static void release(ClassLoader classLoader) {
    }

    public static void releaseAll() {
    }

    // Unsupported operation
    public Object getAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    public String[] getAttributeNames() {
        throw new UnsupportedOperationException();
    }

    public static String objectId(Object o) {
        throw new UnsupportedOperationException();
    }
}
