package ru.yandex.webmaster.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.ArrayUtils;

/**
 * @author aherman
 */
public class WebmasterException extends RuntimeException {
    private final WebmasterExceptionType type;
    private final Map<String, String> errorParameters;

    public WebmasterException(WebmasterExceptionType type, String message) {
        super(message);
        this.type = type;
        this.errorParameters = Collections.emptyMap();
    }

    public WebmasterException(WebmasterExceptionType type, String message, String... parameters) {
        super(message);
        this.type = type;
        this.errorParameters = collectParameters(parameters);
    }

    public WebmasterException(WebmasterExceptionType type, String message, Throwable cause) {
        super(message, cause);
        this.type = type;
        this.errorParameters = Collections.emptyMap();
    }

    public WebmasterException(WebmasterExceptionType type, String message, Throwable cause, String... parameters) {
        super(message, cause);
        this.type = type;
        this.errorParameters = collectParameters(parameters);
    }

    public WebmasterExceptionType getType() {
        return type;
    }

    public Map<String, String> getErrorParameters() {
        return errorParameters;
    }

    static Map<String, String> collectParameters(String... parameters) {
        if (ArrayUtils.isEmpty(parameters)) {
            return Collections.emptyMap();
        }

        Map<String, String> result = new HashMap<>();
        if (parameters.length == 1) {
            result.put(parameters[0], "");
        } else {
            int i = 0;
            while (i < parameters.length - 1) {
                String key = parameters[i];
                String value = parameters[i + 1];

                result.put(key, value);
                i += 2;
            }
            if (i == parameters.length - 1) {
                String key = parameters[parameters.length - 1];
                result.put(key, "");
            }
        }

        return result;
    }
}
