package ru.yandex.webmaster.common;

/**
 * @author aherman
 */
public enum WebmasterExceptionType {
    // Public errors
    XML_LIMITS__DELEGATION_LIMIT_EXCEEDED(WebmasterExceptionSystem.XML_LIMITS),
    XML_LIMITS__LIMIT_ALREADY_DELEGATED(WebmasterExceptionSystem.XML_LIMITS),
    XML_LIMITS__MUST_DELEGATE_TO_OWNER(WebmasterExceptionSystem.XML_LIMITS),

    USER__NOT_LOGGED_IN(WebmasterExceptionSystem.URLS),
    USER__HOST_NOT_ADDED(WebmasterExceptionSystem.USER),
    USER__HOST_NOT_OWNED(WebmasterExceptionSystem.USER),
    USER__IS_BLOCKED(WebmasterExceptionSystem.USER),
    USER__NO_SUCH_USER_IN_PASSPORT(WebmasterExceptionSystem.USER),

    HOST__UNKNOWN_HOST(WebmasterExceptionSystem.HOST),

    REQUEST__REQUIRED_PARAMETER_MISSING(WebmasterExceptionSystem.REQUEST),
    REQUEST__ILLEGAL_PARAMETER_VALUE(WebmasterExceptionSystem.REQUEST),
    REQUEST__ILLEGAL_FILE_PARAMETER(WebmasterExceptionSystem.REQUEST),

    SITEMAPS__SITEMAP_ACCESS_ERROR(WebmasterExceptionSystem.SITEMAPS),
    SITEMAPS__SITEMAP_IS_HOMEPAGE(WebmasterExceptionSystem.SITEMAPS),
    SITEMAPS__SITEMAP_TOO_LONG(WebmasterExceptionSystem.SITEMAPS),
    SITEMAPS__SITEMAP_IS_EMPTY(WebmasterExceptionSystem.SITEMAPS),

    URLS__DISALLOWED_IN_ROBOTS_TXT(WebmasterExceptionSystem.URLS),

    MESSAGES__MESSAGE_NOT_FOUND(WebmasterExceptionSystem.MESSAGES),

    // Internal errors
    INTERNAL__UNABLE_TO_INSTANTIATE_REQUEST(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__UNABLE_TO_READ_JSON_REQUEST(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__UNABLE_TO_READ_REQUEST_BINARY_DATA(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__UNSUPPORTED_REQUEST_PARAMETER_TYPE(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__SQL(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__UNKNOWN(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__PROCESSING_ERROR(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__SITA_ERROR(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__CASSANDRA_ERROR(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__ZOOKEEPER_ERROR(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__DATA_CONSISTENCY(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__DISPATCHER_ERROR(WebmasterExceptionSystem.INTERNAL),
    INTERNAL__CONNECTION_ERROR(WebmasterExceptionSystem.INTERNAL),

    SUPPORT__NOT_SUPPORT_USER(WebmasterExceptionSystem.USER),
    ;
    private final WebmasterExceptionSystem system;

    WebmasterExceptionType(WebmasterExceptionSystem system) {
        this.system = system;
    }

    public WebmasterExceptionSystem getSystem() {
        return system;
    }
}
