package ru.yandex.webmaster.common.addurl.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * CREATE TABLE IF NOT EXISTS tbl_addurl_hosting(
 *     hostname VARCHAR(128) NOT NULL PRIMARY KEY
 *   , add_date TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
 * ) ENGINE = InnoDB;
 *
 * @author aherman
 */
public class TblAddUrlHostingsDao extends AbstractDbService {
    public List<String> getHostings() throws InternalException {
        String q = "SELECT hostname FROM tbl_addurl_hosting";
        return getJdbcTemplate(WMCPartition.nullPartition()).query(q, getMapper());
    }

    private ParameterizedRowMapper<String> getMapper() {
        return new ParameterizedRowMapper<String>() {
            @Override
            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("hostname");
            }
        };
    }
}
