package ru.yandex.webmaster.common.addurl.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import ru.yandex.webmaster.common.addurl.PopularIpInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * CREATE TABLE IF NOT EXISTS tbl_addurl_popular_ip (
 *     backend_host VARCHAR(64) NOT NULL
 *   , date TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
 *   , ip INT NOT NULL
 *   , request_count INT NOT NULL
 *
 *   , PRIMARY KEY (backend_host, ip)
 *   , INDEX (date)
 * ) ENGINE=InnoDB;
 *
 * @author aherman
 */
public class TblAddUrlPopularIpDao extends AbstractDbService {
    public List<PopularIpInfo> list(DateTime fromDate) throws InternalException {
        String q = "SELECT * FROM tbl_addurl_popular_ip WHERE date > ?";
        return getJdbcTemplate(WMCPartition.nullPartition()).query(q, getMapper(), fromDate.toDate());
    }

    public void update(List<PopularIpInfo> popularIps) throws InternalException {
        String q = "REPLACE tbl_addurl_popular_ip SET backend_host = ?, ip = ?, request_count = ?";
        for (PopularIpInfo popularIp : popularIps) {
            getJdbcTemplate(WMCPartition.nullPartition()).update(q, popularIp.getBackendHost(),
                    popularIp.getIp(), popularIp.getRequestCount());
        }
    }

    public void deleteOldIps(LocalDate olderThan) throws InternalException {
        String q = "DELETE FROM tbl_addurl_popular_ip WHERE date < ?";
        getJdbcTemplate(WMCPartition.nullPartition()).update(q, olderThan.toDate());
    }

    private ParameterizedRowMapper<PopularIpInfo> getMapper() {
        return new ParameterizedRowMapper<PopularIpInfo>() {
            @Override
            public PopularIpInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
                String backendHost = rs.getString("backend_host");
                DateTime date = new DateTime(rs.getTimestamp("date"));
                int ip = rs.getInt("ip");
                int requestCount = rs.getInt("request_count");

                return new PopularIpInfo(date, backendHost, ip, requestCount);
            }
        };
    }
}
