package ru.yandex.webmaster.common.cassandra;

import org.springframework.beans.factory.annotation.Required;

import java.util.Set;

/**
 * User: azakharov
 * Date: 30.05.14
 * Time: 18:18
 */
public class ClientFactory {
    private Set<String> nodes;

    private volatile CassandraClient client = null;

    /**
     * Creates new cassandra client. Use only if you need separate cassandra client.
     *
     * @return
     */
    public CassandraClient createClient() {
        return new CassandraClient(nodes);
    }

    /**
     * Creates new cassandra client. Use only if you need separate cassandra client.
     *
     * @return
     */
    private CassandraClient createImmutableClient() {
        return new CassandraClient(nodes) {
            @Override
            public void close() {
                throw new UnsupportedOperationException("Singleton object should not be closed directly");
            }
        };
    }


    /**
     * Returns singleton client object
     *
     * @return
     */
    public CassandraClient getClientInstance() {
        if (client == null) {
            client = createImmutableClient();
        }
        return client;
    }

    @Required
    public void setNodes(Set<String> nodes) {
        this.nodes = nodes;
    }
}
