package ru.yandex.webmaster.common.contentpreview;

import ru.yandex.wmconsole.data.info.BriefHostInfo;

/**
 * @author aherman
 */
public class ContentPreviewSettings {
    private final long hostId;
    private final ContentPreviewType type;
    private final ContentPreviewState state;

    public ContentPreviewSettings(long hostId, ContentPreviewType type,
            ContentPreviewState state)
    {
        this.hostId = hostId;
        this.type = type;
        this.state = state;
    }

    public ContentPreviewSettings(BriefHostInfo hostInfo, ContentPreviewType mobile, ContentPreviewState mobileState) {
        this(hostInfo.getId(), mobile, mobileState);
    }

    public long getHostId() {
        return hostId;
    }

    public ContentPreviewType getType() {
        return type;
    }

    public ContentPreviewState getState() {
        return state;
    }
}
