package ru.yandex.webmaster.common.contentpreview;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster.common.contentpreview.dao.TblContentPreviewSettingsDao;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author aherman
 */
public class ContentPreviewSettingsService {
    private TblContentPreviewSettingsDao tblContentPreviewSettingsDao;

    public List<ContentPreviewSettings> getSettings(BriefHostInfo briefHostInfo) throws InternalException {
        return tblContentPreviewSettingsDao.load(briefHostInfo);
    }

    public void changeSetting(List<ContentPreviewSettings> contentPreviewSettings) throws InternalException {
        List<ContentPreviewSettings> modifySettings = new LinkedList<>();
        List<ContentPreviewSettings> removeSettings = new LinkedList<>();
        for (ContentPreviewSettings setting : contentPreviewSettings) {
            if (setting.getState() == ContentPreviewState.DEFAULT) {
                removeSettings.add(setting);
            } else {
                modifySettings.add(setting);
            }
        }
        if (!modifySettings.isEmpty()) {
            tblContentPreviewSettingsDao.save(modifySettings);
        }

        if (!removeSettings.isEmpty()) {
            tblContentPreviewSettingsDao.remove(removeSettings);
        }
    }

    public Iterator<List<ContentPreviewSettings>> getAllSettings() throws InternalException {
        List<ContentPreviewSettings> contentPreviewSettingses = tblContentPreviewSettingsDao.loadAll();
        final Iterator<ContentPreviewSettings> it = contentPreviewSettingses.iterator();
        if (!it.hasNext()) {
            return Collections.emptyIterator();
        }
        return combineByHost(it);
    }

    static Iterator<List<ContentPreviewSettings>> combineByHost(final Iterator<ContentPreviewSettings> it) {
        return new Iterator<List<ContentPreviewSettings>>() {
            private ContentPreviewSettings previousValue = it.next();

            @Override
            public boolean hasNext() {
                return it.hasNext() || previousValue != null;
            }

            @Override
            public List<ContentPreviewSettings> next() {
                List<ContentPreviewSettings> next = new LinkedList<>();
                next.add(previousValue);
                long currentHostId = previousValue.getHostId();
                previousValue = null;
                while (it.hasNext()) {
                    ContentPreviewSettings current = it.next();
                    if (currentHostId == current.getHostId()) {
                        next.add(current);
                    } else {
                        previousValue = current;
                        break;
                    }
                }

                return next;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Required
    public void setTblContentPreviewSettingsDao(TblContentPreviewSettingsDao tblContentPreviewSettingsDao) {
        this.tblContentPreviewSettingsDao = tblContentPreviewSettingsDao;
    }
}
