package ru.yandex.webmaster.common.health;

import java.lang.management.ManagementFactory;
import java.util.List;

import javax.management.MBeanServer;
import javax.management.ObjectName;

import org.apache.tomcat.jdbc.pool.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

/**
 * @author aherman
 */
public class JMXDbPoolRegistrar implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(JMXDbPoolRegistrar.class);

    private List<DataSource> readDS;
    private List<DataSource> writeDS;

    @Override
    public void afterPropertiesSet() throws Exception {
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        for (int i = 0; i < writeDS.size(); i++) {
            registerWithJMX(platformMBeanServer, writeDS.get(i), "master-" + i);
        }

        for (int i = 0; i < readDS.size(); i++) {
            registerWithJMX(platformMBeanServer, readDS.get(i), "slave-" + i);
        }
    }

    private void registerWithJMX(MBeanServer platformMBeanServer, DataSource dataSource, String dbName) {
        try {
            String url = dataSource.getUrl();
            int hostStart = url.indexOf("//");
            int hostEnd = url.indexOf('/', hostStart + 2);
            String name;
            if (hostStart > 0 && hostEnd > 0) {
                int dbNameEnd = url.indexOf('?', hostEnd);
                name = "jdbcPool:" +
                        "dbName=" + dbName +
                        ",url=\"" + url.substring(hostStart + 2, hostEnd) + ":" + url.substring(hostEnd + 1, dbNameEnd) + "\"" +
                        ",user=" + dataSource.getUsername();
            } else {
                name = "jdbcPool:" +
                        "dbName=" + dbName +
                        ",url=invalid" +
                        ",user=" + dataSource.getUsername();
            }

            log.info("Register JMX for: " + name);
            dataSource.createPool();
            ObjectName objectName = new ObjectName(name);
            platformMBeanServer.registerMBean(dataSource.getPool().getJmxPool(), objectName);
        } catch (Exception e) {
            log.warn("Unable to register DataSource MBean: " + e.getMessage());
        }
    }

    @Required
    public void setReadDataSource(List<DataSource> dataSources) {
        this.readDS = dataSources;
    }

    @Required
    public void setDataSource(List<DataSource> dataSources) {
        this.writeDS = dataSources;
    }

}
