package ru.yandex.webmaster.common.health;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

/**
 * @author aherman
 */
public class JMXMetricsRegistrar implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(JMXMetricsRegistrar.class);

    private MetricRegistry metricRegistry;

    @Override
    public void afterPropertiesSet() throws Exception {
        log.info("Register Metrics in JMX");
        JmxReporter jmxReporter = JmxReporter.forRegistry(metricRegistry).build();
        jmxReporter.start();
    }

    @Required
    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }
}
