package ru.yandex.webmaster.common.health;

import com.codahale.metrics.health.HealthCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmtools.common.service.IndexInfoService;

/**
 * @author aherman
 */
public class XmlSearchConnectedCheck extends HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(XmlSearchConnectedCheck.class);

    private String checkHostname;
    private IndexInfoService indexInfoService;

    @Override
    protected Result check() throws Exception {
        log.debug("Try to check host: {}", checkHostname);
        Long pagesCount = indexInfoService.getIndexCount(checkHostname, "/");
        if (pagesCount > 0) {
            log.debug("Pages in index[{}]: {}", checkHostname, pagesCount);
            return Result.healthy("Host [%s] has pages in index: %d", checkHostname, pagesCount);
        } else {
            log.debug("No pages in index[{}]", checkHostname);
            return Result.unhealthy("Host [%s] hasn't been indexed", checkHostname);
        }
    }

    @Required
    public void setCheckHostname(String checkHostname) {
        this.checkHostname = checkHostname;
    }

    @Required
    public void setIndexInfoService(IndexInfoService indexInfoService) {
        this.indexInfoService = indexInfoService;
    }
}
