package ru.yandex.webmaster.common.history.dao;

import java.util.Date;

import org.joda.time.DateTime;

import ru.yandex.wmconsole.data.WMCHistoryObjectTypeEnum;
import ru.yandex.wmconsole.data.info.UsersHostsInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.data.HistoryActionEnum;
import ru.yandex.wmtools.common.data.IHistoryAction;
import ru.yandex.wmtools.common.data.IHistoryObjectType;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * @author aherman
 */
public class TblHistoryDao extends AbstractDbService {
    public DateTime getMaxAddDate(UsersHostsInfo info) throws InternalException {
        String q = "SELECT MAX(performed_on) FROM tbl_history WHERE user_id = ? AND object_id = ? AND action = ? AND type = ?";
        Date hostAddDate = getJdbcTemplate(WMCPartition.nullPartition()).safeQueryForTimestamp(q,
                info.getUserId(),
                info.getHostId(),
                HistoryActionEnum.ADD.getValue(),
                WMCHistoryObjectTypeEnum.HOST.getValue()
        );

        if (hostAddDate != null) {
            return new DateTime(hostAddDate);
        } else {
            return null;
        }
    }

    public void addHistoryQuery(Long realUserId, Long virtualUserId, IHistoryAction historyAction,
            IHistoryObjectType historyObjectType, Long objectId, String newValue) throws InternalException {
        String q = "INSERT INTO tbl_history (user_id, virtual_user_id, action, object_id, type, performed_on) " +
                " VALUES (?, ?, ?, ?, ?, NOW())";
        getJdbcTemplate(WMCPartition.nullPartition())
                .update(q, realUserId, virtualUserId, historyAction.getValue(), objectId, historyObjectType.getValue());
    }
}
