package ru.yandex.webmaster.common.host;

import org.joda.time.DateTime;

/**
 * @author aherman
 */
public class HostEvent {
    private final int eventId;
    private final long hostId;
    private final DateTime date;
    private final HostEventType eventType;
    private final long eventByUserId;
    private final long eventForUserId;
    private final String rawData;

    public HostEvent(int eventId, long hostId, DateTime date, HostEventType eventType, long eventByUserId,
            long eventForUserId, String rawData)
    {
        this.eventId = eventId;
        this.hostId = hostId;
        this.date = date;
        this.eventType = eventType;
        this.eventByUserId = eventByUserId;
        this.eventForUserId = eventForUserId;
        this.rawData = rawData;
    }

    public int getEventId() {
        return eventId;
    }

    public long getHostId() {
        return hostId;
    }

    public DateTime getDate() {
        return date;
    }

    public HostEventType getEventType() {
        return eventType;
    }

    public long getEventByUserId() {
        return eventByUserId;
    }

    public long getEventForUserId() {
        return eventForUserId;
    }

    public String getRawData() {
        return rawData;
    }

    @Override
    public String toString() {
        return "HostEvent{" +
                "eventId=" + eventId +
                ", hostId=" + hostId +
                ", date=" + date +
                ", eventType=" + eventType +
                ", eventByUserId=" + eventByUserId +
                ", eventForUserId=" + eventForUserId +
                ", rawData='" + rawData + '\'' +
                '}';
    }
}
