package ru.yandex.webmaster.common.host;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum HostEventType implements IntEnum {
    UNKNOWN(0),

    HOST_ADDED(1),
    HOST_REMOVED(2),

    HOST_VERIFIED(3),
    HOST_AUTOVERIFIED(4),
    HOST_VERIFICATION_REVOKED(5),
    HOST_VERIFICATION_DELEGATED(6),

    WEBMASTER3_USER_HOST_RETRY_EVENT(7)
    ;

    private final int value;

    private HostEventType(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<HostEventType> R = IntEnumResolver.r(HostEventType.class);
}
